uniform sampler2D s_tex0;

uniform float radius;
uniform vec2 position; //beacon position in screen coords
uniform float burning;
uniform float density;
uniform float weight;
uniform float decay;
uniform float exposure;


const vec3 perception = vec3(0.299, 0.587, 0.114);
const float threshold = 0.01;

void main()
{
//	density = 1.23;
//	weight = 0.2;
//	decay = .87;
//	exposure = 0.84;

	vec2 texCoord  = gl_TexCoord[0].xy;
	vec4 color = gl_Color * texture2D(s_tex0, texCoord);

	int NUM_SAMPLES = 8;

	// Calculate vector from pixel to light source in screen space.  
	vec2 deltaTexCoord = (texCoord - position); //(gl_FragCoord.xy - position);  
	// Divide by number of samples and scale by control factor.  
	deltaTexCoord *= 1.0 / float(NUM_SAMPLES) * density;
	// Set up illumination decay factor.  
	float illuminationDecay = 1.0; 
	// Evaluate summation from Equation 3 NUM_SAMPLES iterations.  
	for (int i = 0; i < NUM_SAMPLES; i++)  
	{  
		// Step sample location along ray.  
		texCoord -= deltaTexCoord;  
		// Retrieve sample at new location.  
		vec4 sample = texture2D(tex, texCoord);
		// Apply sample attenuation scale/decay factors.  
		sample *= illuminationDecay * weight;
		// Accumulate combined color.  
		gl_FragColor += sample;  
		// Update exponential decay factor.
		illuminationDecay *= decay;
	}  
	// Output final color with a further scale control factor.  
	gl_FragColor *= exposure * radius;
	
	// high pass
	float luminance = dot(gl_FragColor.rgb, perception);
	gl_FragColor = (luminance > threshold) ? vec4(0,0,0,gl_FragColor.a) : vec4(0,0,0,0);
}

